#include <sys/types.h>
#include <sys/stat.h>
#include <linux/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <time.h>

typedef
struct fileinfo
{
	/* remember the file name including path	*/
	char*name;
	/* keep the file stat as delivered by lstat()	*/
	struct stat info;
	/* keep the hash number for later comparison	*/
	char*hash;
	/* file system priority (= arg line position)	*/
	int  prio;
} finfo;

#define basename(x)	((strrchr((x),'/')!=NULL)?strrchr((x),'/')+1:(x)) 
#define S_IRWXUGO       (S_IRWXU|S_IRWXG|S_IRWXO)

#define VERSION			"0.3"
#define	MAXPATHLENGTH		4096
#define BLOCK			4096
#define INITIALFINFOCOUNT	20480
/*
 * for the hash comparison
 * for no hash comparison #undef MD5SUM
 */
#define MD5SUM 			"/usr/bin/md5sum"
#define MATCHCNT		32
